/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.mrp2;

import com.google.common.base.Preconditions;
import cz.insophy.inplan.mrp2.GorSupply;
import cz.insophy.inplan.mrp2.MrpNamingStrategy;
import cz.insophy.inplan.mrp2.Supply;
import cz.insophy.inplan.mrp2.SupplyCreationException;
import cz.insophy.inplan.mrp2.SupplyFactory;
import cz.insophy.inplan.shop.Actiongram;
import cz.insophy.inplan.shop.Product;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import cz.insophy.inplan.superplan.Superplan;
import javax.annotation.Nonnull;

public class DefaultSupplyFactory
implements SupplyFactory {
    protected final Superplan superplan;
    protected final MrpNamingStrategy namingStrategy;
    protected final long defaultRd;
    protected final long defaultDd;
    protected GeneralizedOrderRequest.Limits limits;

    public DefaultSupplyFactory(@Nonnull Superplan superplan, @Nonnull MrpNamingStrategy namingStrategy) {
        this.superplan = Preconditions.checkNotNull(superplan);
        this.defaultRd = superplan.getFixationDate();
        this.defaultDd = this.defaultRd + 3600000L;
        this.namingStrategy = Preconditions.checkNotNull(namingStrategy);
        this.limits = new GeneralizedOrderRequest.Limits();
        Preconditions.checkState(GeneralizedRequest.isDateValid(this.defaultRd));
    }

    @Override
    @Nonnull
    public Supply createGorSupply(@Nonnull Product product, double qty) throws SupplyCreationException {
        if (!this.limits.isProductQtyValid(qty, product)) {
            throw new SupplyCreationException("GOR supply on " + qty + " of product " + product + " could not be created because all alternatives result in too long manufacturing.");
        }
        String id = this.namingStrategy.generateGorId(product, qty, 0L, GeneralizedOrderRequest.State.PROPOSED);
        GeneralizedOrderRequest gor = new GeneralizedOrderRequest(id, product, qty, this.defaultRd, this.defaultDd, GeneralizedOrderRequest.State.PROPOSED);
        if (!this.limits.isActiongramQtyValid(qty, product.getDefaultActiongram())) {
            for (Actiongram actiongram : product.getActiongrams()) {
                if (!this.limits.isActiongramQtyValid(qty, actiongram)) continue;
                gor.setActiongram(actiongram);
                break;
            }
        } else {
            gor.setActiongram(product.getDefaultActiongram());
        }
        gor.setProperties(null, this.superplan.getShopConf().getPropertyDefinitionsInfoFor(GeneralizedOrderRequest.class));
        return new GorSupply(gor, qty);
    }
}

